const express = require('express');
const fileUpload = require('express-fileupload');
const app = express();

// default options
app.use(fileUpload());

app.post('/upload', function(req, res) {
	console.info('handler reached')

	if (!req.files || Object.keys(req.files).length === 0) {
		return res.status(400).send('No files were uploaded.');
	}
	// The name of the input field (i.e. "sampleFile") is used to retrieve the uploaded file
	let sampleFile = req.files.file;

	// Use the mv() method to place the file somewhere on your server
	res.json({
		message: "OK",
		sampleFile: sampleFile.name
	});
});

const server =app.listen(process.env.PORT || 4000, () => {
	console.info('Server has been started!')
})
server.on("connection", c => {
	console.info('new connection, increasing timeout')
	c.setTimeout(3600 * 1000);
	c.setKeepAlive(true);
	c.on("error", e => {
		console.error('socket error', e);
	});
})
server.setTimeout(3600 * 1000)
